<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Rate extends Model
{
    use HasFactory;

    protected $table = 'rates'; // Explicitly define the table name if different from 'rate'
    protected $primaryKey = 'rate_id'; // Define the primary key if it's not 'id'
    public $timestamps = true; // Enable timestamps (created_at, updated_at)

    protected $fillable = [
        'profile_id',
        'hourly_min',
        'hourly_max',
        'currency_id',
        'is_negotiable',
        'factors',
    ];

    protected $casts = [
        'hourly_min' => 'decimal:2', // Cast to decimal with 2 decimal places
        'hourly_max' => 'decimal:2', // Cast to decimal with 2 decimal places
        'is_negotiable' => 'boolean', // Cast to boolean
        'factors' => 'array', // Cast to array for JSON storage
        'created_at' => 'datetime',
        'updated_at' => 'datetime',
    ];

    /**
     * Define the relationship with the CandidateProfile model.
     */
    public function candidateProfile()
    {
        return $this->belongsTo(CandidateProfile::class, 'profile_id', 'Profile_id');
    }

    /**
     * Define the relationship with the Currency model.
     */
    public function currency()
    {
        return $this->belongsTo(Currency::class, 'currency_id', 'Currency_id');
    }
}
